setwd('F:/')###############################################
### Plot creator ##############################
###############################################
### (c) T.R. Vonnahme #########################
###############################################
### Script for creation of Figures 3 and 5 ####
### AND data used in the script
###############################################

###Journal: Biogeosciences: special issue: Freshwater ecosystems in changing permafrost landscapes
###Title of the paper: Controls on microalgal community structures in cryoconite holes upon high Arctic glaciers, Svalbard

###Authors and affiliations:
#########T.R. Vonnahme1,2,*  M. Devetter1,3  J. D. rsk1,4  M. aback1,5  J. Elster1,6
#########[1] Centre for Polar Ecology, Faculty of Science, University of South Bohemia, Cesk Budejovice, Czech Republic
#########[2] University of Konstanz, Constance, Germany
#########[3] Biology Centre of the Academy of Science of the Czech Republic, Institute of Soil Biology, Cesk Budejovice, Czech Republic
#########[4] Department of Ecology, Charles University, Prague, Czech Republic
#########[5] British Antarctic Survey, Cambridge, UK
#########[6] Institute of Botany, Academy of the Science of the Czech Republic, Trebon, Czech Republic
#########[*] {now at: Max Planck Institute for Marine Microbiology, Bremen, Germany} 
#########Correspondence to: T.R. Vonnahme (t.r.vonnahme@gmail.com) 

################################################
################################################
################################################

setwd("F://")

################################################
### Figure 3 ###################################
#################################################



pdf("F://Fig3.pdf", width=6.85, height=2.7, family="Times", pointsize=10)

par(mfrow=c(1,3))
par(oma=c(0,3,0,0))

############################################
###A) data import: summarized data #########
env<-read.table("envaverage2.txt", header=T)

### subset with used variables, with NAs##############
all<-data.frame(env$ID, env$site, env$elevation, env$sedmass,
    env$water, env$om, env$depth, env$slopedist,
    env$Chlorococcales, env$Zygnemales, env$coc_cyano, env$filament_cyano,
    env$Tardigrades, env$Rotifers, env$Ciliates)
specA<-data.frame(all$env.Chlorococcales, all$env.Zygnemales, all$env.filament_cyano, 
       all$env.coc_cyano, all$env.Tardigrades, all$env.Rotifers, all$env.Ciliates)
       colnames(specA)<-c("Chl", "Zyg", "Nos", "Osc", "Tar", "Rot", "Cil") 
       row.names(specA)<-all$env.ID
algA<-data.frame(all$env.Chlorococcales, all$env.Zygnemales, all$env.filament_cyano, 
       all$env.coc_cyano)
       colnames(algA)<-c("Chl", "Zyg", "Nos", "Osc") 
       row.names(algA)<-all$env.ID
invA<-data.frame(all$env.Tardigrades, all$env.Rotifers, all$env.Ciliates)
       colnames(invA)<-c( "Tar", "Rot", "Cil") 
       row.names(invA)<-all$env.ID



###############################################################
###Fig3a

algA2<-cbind(algA/1000000,env$site)
algA3<-aggregate(cbind(Zyg, Chl, Osc, Nos) ~ env$site, mean, data=algA2)

se=function(x)
{ sd(x)/sqrt(length(x)) }

algA3b<-aggregate(cbind(Zyg, Chl, Osc, Nos) ~ env$site, se, data=algA2)


algA4<-as.data.frame(t(algA3[,-1]))
colnames(algA4)<-c("E","HC","NC","NI","NL","NR")
row.names(algA4)<-c("Zygnemales", "Chlorococcales", "Oscillatoriales","Nostocales")
algA4b<-as.data.frame(t(algA3b[,-1]))
colnames(algA4b)<-c("E","HC","NC","NI","NL","NR")
se<-as.matrix(algA4b)

mp<-barplot(as.matrix(algA4), beside=T, 
xlab="Sites", ylim=c(0,220),main="a", cex.main=3, lwd=0.25,
col=c("brown","red","seagreen1", "seagreen"),
ylab=expression(paste("Micoalgae biovolumes [",mu,"m",cm^-2,"]x",10^6)),
oma=c(0,2,0,0))
legend('top', c("Zygnemales", "Chlorococcales", "Oscillatoriales","Nostocales"),
pch=15, col=c("brown","red","seagreen1", "seagreen"), cex=1) 


error.bar <- function(x, y, upper, lower=upper, length=0.03,...){
    if(length(x) != length(y) | length(y) !=length(lower) | length(lower) != length(upper))
    stop("vectors must be same length")
    arrows(x,y+upper, x, y-lower, angle=90, code=3, length=length,lwd=0.25, ...)
    }

error.bar(as.matrix(mp), as.matrix(algA4), as.matrix(se))


######### data for microalgae on different sites: ####################

###mean values:
algA4
### standard errors
algA4b


#######################################################################
###Fig3b

invA2<-cbind(invA,env$site)
invA3<-aggregate(cbind(Tar, Rot, Cil) ~ env$site, mean, data=invA2)

se=function(x)
{ sd(x)/sqrt(length(x)) }

invA3b<-aggregate(cbind(Tar, Rot, Cil) ~ env$site, se, data=invA2)

invA4<-as.data.frame(t(invA3[,-1]))
colnames(invA4)<-c("E","HC","NC","NI","NL","NR")
invA4b<-as.data.frame(t(invA3b[,-1]))
colnames(invA4b)<-c("E","HC","NC","NI","NL","NR")
se<-as.matrix(invA4b)
row.names(invA4)<-c("Tardigrada", "Rotifera","Ciliates")

mp<-barplot(as.matrix(invA4), beside=T, legend=F,main="b", cex.main=3,lwd=0.25,
xlab="Sites", ylim=c(0,40), col=c("brown","red","green"),
ylab=expression(paste("Grazer abundances [Ind. ",cm^-2,"]")))

legend('top', c("Tardigrada","Rotifera","Ciliates"),
pch=15, col=c("brown","red","green"), cex=1) 

error.bar(as.matrix(mp), as.matrix(invA4), as.matrix(se))

######### data for grazer on different sites: ####################

###mean values:
invA4
### standard errors
invA4b

#################################################################
###Fig3c

 data2<-read.table("16S_Miseq_2.txt", header=T)

rownames(data2)<-data2[,1]
data2<-data2[,-1]
colnames(data2)<-c("Arthronema","Nostoc","Microcoleus",
"Calothrix","Symploca","Pseudoanabaena","Leptolyngbya")

data2<-t(data2)
data2<-data2[,1:3]
se<-sd(data2[,1:3]/sqrt(2))
barplot(as.matrix(data2)
, legend=F, main="c", cex.main=3,lwd=0.25,
col=c("orangered","seagreen1","orangered4","seagreen","green","yellow","blue"),
xlab="Sites", ylab="Proportion of cyanobacteria in 16S reads [%]",
xlim=c(0,4), ylim=c(0,50))

legend('topright', 
c(
(expression(italic("Leptolyngbya sp."))),
(expression(italic("Pseudoanabaena sp."))),
(expression(italic("Symploca sp."))),
(expression(italic("Calothrix spp."))),
(expression(italic("Microcoleus sp."))),
(expression(italic("Nostoc spp."))),
(expression(italic("Arthronema sp.")))),
pch=15,col=c("blue","yellow","green","seagreen","orangered4","seagreen1","orangered"))

######### data for the 16S reads on species levels on different sites: #######

###values:
data2



##################################################################
dev.off()
###################################################################


##################################################################
###Figure 5 ######################################################
##################################################################


pdf("F://Fig5.pdf", width=6.85, height=6.85, family="Times", pointsize=9.5)

par(mfrow=c(2,1))
par(oma=c(0,3,0,0))

##########################################################################

spec<-read.table("spec_sc3.txt", header=T, row.names=1)
colnames(spec)<-c("Chroococcales","Nostocales<11","Nostocales>11",
"Oscillatoriales<25","Oscillatoriales=25",
"Oscillatoriales>25","Chlorococcales<11","Chlorococcales>11","Zygnemales")
colnames(spec)<-c("Chr","Nos<11","Nos>11","Osc<25","Osc=25",
"Osc>25","Chl<11","Chl>11","Zyg")
spect <- t(spec)
spectsum <- 


mp<-barplot((100*spect), xlab="Sites", main="a",cex.main=3,
ylab="Proportion of size classes [%]",
col=c("325","300","black","yellow","orange","146","lightgreen","green","darkgreen")
, xlim=c(0,8),legend=T)
#ylab=expression(paste("Microalgae biovolume [",mu,"m"," ",cm^-2,"]")))

#####################################################################

data<-read.table("median_sizes.txt", header=T, row.names=1)
alg<-data.frame(data[,2:5])
colnames(alg)<-c("Nostocales","Oscillatoriales","Chlorococcales","Zygnemales")
boxplot(alg, ylab=expression(paste("Quantiles of size [",mu,"m]")), main="b", 
cex.main=3)

######################################################################
dev.off()
######################################################################


######################################################################
### additional data for Rotifer genera ###############################
######################################################################

rot<-data.frame(env$site, env$Macrotrachella, env$Adineta, env$Encentrum)
colnames(rot)<-c("site","Macrotrachella","Adineta","Encentrum")
rot2<-aggregate(cbind(rot$Macrotrachella, rot$Adineta) ~ rot$site, mean, data=rot)

###mean values
rot2

 se=function(x)
{ sd(x)/sqrt(length(x)) }
 rot3<-aggregate(cbind(rot$Macrotrachella, rot$Adineta, rot$Encentrum) ~ rot$site, se, data=rot)

###standard errors
 rot3